#include "cliparse.h"
#include <stdio.h>

/*
  parse a tring into '*argv[]', delimitor is space or tab
  param pRawString, the whole line of command string
  param argv, parsed argument string array
  return number of parsed argument
*/
static int StringToArgs(char *pRawString, char *argv[])
{
	int argc = 0, i = 0, strsize = 0;

	if (pRawString == NULL)
		return 0;

	strsize = strlen(pRawString);

	while (argc < MAX_CMD_ARGS)
	{
		// skip white space characters of string head
		while ((*pRawString == ' ') || (*pRawString == '\t'))
		{
			++pRawString;
			if (++i >= strsize)
				return (argc);
		}

		if (*pRawString == '\0' || *pRawString == '\r' || *pRawString == '\n')
		{
			argv[argc] = NULL;
			return (argc);
		}

		argv[argc++] = pRawString;

		// find end of string
		while (*pRawString && (*pRawString != ' ') && (*pRawString != '\t') && (*pRawString != '\r') && (*pRawString != '\n'))
			++pRawString;

		if (*pRawString == '\0')
		{
			argv[argc] = NULL;
			return (argc);
		}

		*pRawString++ = '\0';
	}

	printf("Too many arguments. Maximum args supported is %d!\n", MAX_CMD_ARGS);

	return (0);
}

int CommandParse(char* cmdline)
{
	int  argc = 0;
	char *argv[MAX_CMD_ARGS + 1] = { 0 };
	static char saveCmd[CMD_MAX_LENGTH + 1];

	int ix, i;
	int commandsCount = GetCommandsCount();
	const CMD_DESCRIPTOR* pDcpt;

	strncpy(saveCmd, cmdline, sizeof(saveCmd));     // make a copy of the command

	// parse a command string to *argv[]
	argc = StringToArgs(saveCmd, argv);

	if (argc != 0)
	{   // ok, there's smth here
		strupr(argv[0]);
		for (ix = 0, pDcpt = commandsTable; ix < commandsCount; ix++, pDcpt++)
		{
			if (!strcmp(argv[0], pDcpt->cmdStr))
			{   // command found
				//printf("Execute cmd '%s'. Description: %s.\n", pDcpt->cmdStr, pDcpt->cmdDescr);
				//printf("Args count = %d\n", argc - 1);
				//for (i = 1; i < argc; i++)
					//printf("arg[%d] = %s\n", i, argv[i]);
				return (*pDcpt->cmdFnc)(argc, argv);     // call command handler
			}
		}
		// command not found
		printf("Command Processor: unknown command.\n");
	}
	else
	{
		printf("Command Processor: empty command.\n");
	}
	return 0;
}